
#macro MakeSpineBunch(Pt, Dir, Jitter, Len, BaseRad, Num)
	#local L = 0;
	#while(L < Num)
		#local NewDir = vnormalize(Dir + Jitter*(< rand(RS), rand(RS), rand(RS)>*2 - 1));
		cone {Pt, BaseRad, Pt + NewDir*Len, 0}
		#local L = L + 1;
	#end
#end
#macro MakeSpineRows(Body, Stretch, AltJitter, Ridges, Bunches, Spines, SpineJitter, SpineLen, SpineRad)
	#declare J = 0;
	#local AltDelta = 180/Bunches;
	union {
		#while(J < Ridges)
			#declare K = 0;
			#while(K < Bunches)
				#declare Orig = vrotate(-y*50, x*(K + rand(RS)*AltJitter)*AltDelta);
				#declare Orig = vrotate(Orig, y*(360*J/Ridges + 360/(Ridges*4)))*Stretch;
				#declare PtNorm = y;
				#declare Pt = trace(Body, Orig,-Orig, PtNorm);
				MakeSpineBunch(Pt, PtNorm, SpineJitter, SpineLen, SpineRad, Spines)
				#declare K = K + 1;
			#end
			#declare J = J + 1;
		#end
	}
#end

#declare sinw = function (x) {(sin(x) + 1)/2}

#declare Ridges = 40;
#declare RidgeDepth = 0.075;

#declare cactus1Body =
isosurface {
	function {sqrt(x*x + pow(y - sqrt((x*x/4) + (z*z/4))*1.5, 2) + z*z) - 1 -
		(sin(atan2(x, z)*Ridges)*0.5*RidgeDepth)
	}
	threshold 0
        max_gradient 5
        
	contained_by {sphere {< 0, 0, 0>, 3.1}}
	texture {
		pigment {radial
			color_map {
				[0 color rgb < 0.3, 0.85, 0.4>*0.8]
				[0.65 color rgb < 0.3, 0.85, 0.4>*0.8]
				[1 color rgb < 0.3, 0.85, 0.4>*0.2]
			}
			frequency Ridges sine_wave
		}
		normal {dents 0.1 poly_wave 2 scale < 1, 0.15, 1>}
	}
}
#declare Cactus1 =
union {
	object {cactus1Body}
	object {MakeSpineRows(cactus1Body, 1, 0.2, Ridges, 24, 3, 0.5, 1, 0.01)
		texture {pigment {color rgb < 0.98, 0.98, 0.5>}}
	}
	scale < 1, 0.75, 1>
	translate y*0.35
}


#declare Ridges = 32;
#declare RidgeDepth = 0.1;
#declare cactus2Body =

isosurface {
	function {
		f_r(x, y*0.35, z) - 1 - sqrt(x*x + z*z)*0.2
		- (sinw(atan2(x, z)*Ridges)*RidgeDepth)
	}
	threshold 0
	max_gradient 5
	contained_by {sphere {< 0, 0, 0>, 3.1}}
	texture {
		pigment {color rgb < 0.3, 0.85, 0.4>}
		normal {bozo 0.1 scale < 1, 0.15, 1>}
	}
}

#declare Cactus2 =
union {
	object {cactus2Body}
	object {MakeSpineRows(cactus2Body, < 1, 3, 1>, 1, Ridges, 64, 3, 1, 0.5, 0.01)
		texture {pigment {color rgb < 0.98, 0.98, 0.5>}}
	}
	translate y*2
}



#declare Ridges = 75;
#declare RidgeDepth = 0.05;
#declare cactus3Body =

isosurface {
	function {
		sqrt(x*x + pow((y/1.5),2) + z*z) - 1 - sqrt(x*x + z*z)*0.2
		- (sinw(atan2(x, z)*Ridges)*RidgeDepth)
	}
	threshold 0
	max_gradient 5
	contained_by {sphere {< 0, 0, 0>, 3.1}}
	texture {
		pigment {color rgb < 0.1, 0.5, 0.25>}
		normal {bozo 0.1 scale 0.15}
	}
}
#declare Cactus3 =
union {
	object {cactus3Body}
	object {MakeSpineRows(cactus3Body, < 1, 1.5, 1>, 1, Ridges, 24, 5, 1, 0.35, 0.01)
		texture {pigment {color rgb < 0.98, 0.98, 0.85>}}
	}
	translate y*1.25
}


 object {Cactus2 scale 1.0 translate <-4.0,0,-5> }

 object {Cactus1 scale 0.4 translate < 0, 0,3>}
 object {Cactus2 scale 0.4 translate <-1,0,5> }
 object {Cactus3 scale 0.4 translate <-3, 0,3>}

 object {Cactus2 scale <0.3,0.7,0.3> translate <-9.5,0,ds+9> }
 object {Cactus2 scale <0.3,0.6,0.3> translate <-11.5,0,ds+10> }

#if (small_plants>0) #include "small plants.inc" #end